/**
 * Item: object representing single news
 * */
function Item(params){
	this.title = params.title ? params.title : '';
	this.content = params.content ? params.content : '';
	this.url = params.url ? params.url : '';
	this.pubDate = params.pubDate ? params.pubDate : '';
	this.id = this.id ? this.id : this.url + "?feedtitle=" + this.title;
	this.read = params.read ? params.read: false;
	this.feed = params.feed ? params.feed : null;
}
Item.prototype = {
	/**
	 * setting read property = True
	 * */
	markAsRead : function(){
		this.read = true;
	},
	/**
	 * assign feed to item
	 * @param {Feed} feed
	 * */
	setFeed : function(feed){
		this.feed = feed;
	},
	/**
	 * attach event listeners to item element
	 * onFocus, onClick
	 * */
	addListeners : function(){
		if(!this.el) return;
		
		this.el.addEventListener('click',function(e){
			e.preventDefault();
			e.stopPropagation();
			if(document.moveFocusRight != undefined){document.moveFocusRight();}
		}, false);
		
		var that = this;
		
		this.el.addEventListener('focus',function(e){
			e.preventDefault();
			e.stopPropagation();
			var isOpened = that.el.hasClass( 'active' );
			var list = document.getElementById( 'item_list' ),
				items = list.getElementsByClassName( 'item' );
			
			for( var i=0; i< items.length; i++ ){
				if( items[i].id != that.el.id ) items[i].removeClass( 'active' );
				else that.el.addClass( 'active' );
			}
			
			Application.UI.scrollList(that.el,'item_list');
			
			var isRead = that.read;
			if( !isRead ) {
				that.markAsRead();
				that.el.addClass( 'read' );
			}
			if( !isOpened ){
				Application.UI.active.replaceContent( that.el );
			} 
		}, false);
	},
	/**
	 * @returns html element with item basic content: title , publish date and icon
	 * */
	getEl : function(elId) {
		if (this.el)
			return this.el;
		this.el = document.createElement('div');
		this.el.innerHTML = Application.UI.renderTmpl(this.TMPL, {
			feed : this.feed.title,
			pubDate : this.pubDate,
			pubDateFormatted : O.Utils.Date.formatTime( this.pubDate ),
			title : this.title,
			read : this.read,
			color : this.feed.color
		});
		this.el = this.el.firstElementChild;
		//this.el.item = this;
		this.addListeners();
		this.el.cnt = this.getElContent();
		
		return this.el;
	},
	/**
	 * @returns html element with item extended content including title and description
	 * */
	getElContent : function() {
		if(this.elContent){
			return this.elContent;
		}
		this.elContent = document.createElement('div');
		this.elContent.innerHTML = Application.UI.renderTmpl(this.TMPL_CONTENT, {
			title : this.title,			
			description : this.content,
			url : this.url
		});

		this.elContent = this.elContent.firstElementChild;
		
		link = this.elContent.querySelector('a');
		link.addEventListener( 'click', function(e){
			e.stopPropagation();
			window.location = this.href;
		}, false );
		var that = this;
		link.addEventListener( 'focus', function(e){
			Application.UI.active.nav.scrollUp(0);
		}, false );
		
		return this.elContent;
		
	},
	TMPL : ['<a class="item<% if(read) { %> read<% } %>" href="#"><article>',
		        '<span class="icon"<% if(color) { %> style="background-color:<%=color%>"<% } %>>',
		        	'<em><%=feed%></em>',
		        '</span>',
		        '<header>',
		        	'<time class="pubDate" datetime="<%=pubDate%>"><%=pubDateFormatted%></time>',
		        	'<h5><%=title%></h5>',
		        '</header>',
	        '</article></a>'].join(''),
    TMPL_CONTENT : [ 
            '<article>',
         		'<h5><a href="<%=url%>" id="openItem"><%=title%></a></h5>',
         		'<div class="description"><%=description%></div>',
         	'</article>'
            ].join('')
}